#include <bits/stdc++.h>

using namespace std;

const int maxN = 150000;
const int maxK = 300100;
const double maxT = 1000000100;
int long long N,K;
pair<int, pair<double,double> > trkaci[maxN];
pair<int, pair<double,double> > niz2[maxN];

int initial_positions[maxN];
int final_positions[maxN];



// Nalazenje broja preticanja uzeo iz stare verzije zadatka 99% radi
long long merge_and_count_inversions(int arr[], int start, int mid, int end, int temp[]) {
    int i = start, j = mid + 1, k = start;
    long long inv_count = 0;

    while (i <= mid && j <= end) {
        if (arr[i] <= arr[j]) {
            temp[k] = arr[i];
            i++;
        } else {
            temp[k] = arr[j];
            inv_count += (mid - i + 1);
            j++;
        }
        k++;
    }

    while (i <= mid) {
        temp[k] = arr[i];
        i++;
        k++;
    }

    while (j <= end) {
        temp[k] = arr[j];
        j++;
        k++;
    }

    for (i = start; i <= end; i++) {
        arr[i] = temp[i];
    }

    return inv_count;
}

long long merge_sort_and_count_inversions(int arr[], int start, int end, int temp[]) {
    long long inv_count = 0;

    if (start < end) {
        int mid = (start + end) / 2;
        inv_count += merge_sort_and_count_inversions(arr, start, mid, temp);
        inv_count += merge_sort_and_count_inversions(arr, mid + 1, end, temp);
        inv_count += merge_and_count_inversions(arr, start, mid, end, temp);
    }

    return inv_count;
}

long long count_overtakes(int initial_positions[], int final_positions[]) {
    int temp[N];

    // Map initial positions to their corresponding final positions
    map<int, int> position_mapping;
    for (int i = 0; i < N; i++) {
        position_mapping[final_positions[i]] = i;
    }

    int mapped_initial_positions[N];
    for (int i = 0; i < N; i++) {
        mapped_initial_positions[i] = position_mapping[initial_positions[i]];
    }

    // Count inversions using merge sort
    long long result = merge_sort_and_count_inversions(mapped_initial_positions, 0, N - 1, temp);

    return result;
}



// Sortira niz trkaca po pocetnim pozicijama
bool custom_Sort(pair<int, pair<double,double> > p1, pair<int, pair<double,double> > p2)
{
    if(p1.second.first == p2.second.first)
    {
        cout<<"T";
        return p1.second.second > p2.second.second;
    }
    else
    {
        return p1.second.first > p2.second.first;
    }
}


// Racuna broj preticanja posle t vremena
void noviNiz(double t)
{
    // Pravimo raspored posle t vremena
    for(int i=0;i<N;i++)
    {
        niz2[i].first = trkaci[i].first;
        niz2[i].second.first = trkaci[i].second.first + (trkaci[i].second.second) * (t + 0.000000001);
        niz2[i].second.second = trkaci[i].second.second;
    }

    sort(niz2, niz2 + N, custom_Sort);

    for(int i=0;i<N;i++)
    {
        initial_positions[i] = trkaci[i].first;
        final_positions[i] = niz2[i].first;
    }
}


// Pronalazi n-to preticanje
double najmanje;
bool checked = false;
void nadjiPreticanje(double levaGranica, double desnaGranica)
{
    // Postavljamo preciznost
    if(desnaGranica - levaGranica < 0.000001)
    {
        return;
    }

    // Radimo binarnu pretragu za resenje
    double mid = levaGranica + (desnaGranica - levaGranica) / 2;

    noviNiz(mid);
    int x = count_overtakes(initial_positions, final_positions);

    // Ako je x = k nasli smo k to preticanje
    if(x == K)
    {
        if(checked == false)
        {
            checked = true;
            najmanje = mid;
        }
        else
        {
            if(najmanje > mid)
            {
                najmanje = mid;
            }
        }
    }

    // Ako je neposredno posle i pretoga nase preticanje prihvatamo resenje
    // U istom trenutku se deilo vise od K preticanja
    noviNiz(mid-0.000001);
    int xPre = count_overtakes(initial_positions, final_positions);
    noviNiz(mid+0.000001);
    int xPosle = count_overtakes(initial_positions, final_positions);
    if(xPre < K and xPosle > K and x > K)
    {
        if(checked == false)
        {
            checked = true;
            najmanje = mid;
        }
        else
        {
            if(najmanje > mid)
            {
                najmanje = mid;
            }
        }
    }

    // U suprotnom nastavljamo pretragu
    if(x < K)
    {
        nadjiPreticanje(mid, desnaGranica);
    }
    else
    {
        nadjiPreticanje(levaGranica, mid);
    }
    return;
}


int main()
{
    // Ulaz
    cin>>N>>K;
    for(int i=0;i<N;i++)
    {
        int X,V;
        cin>>X>>V;
        trkaci[i].second.first = X;
        trkaci[i].second.second = V;
    }

    // Sortiramo niz parova po pocetnoj poziciji
    sort(trkaci, trkaci + N, custom_Sort);
    for(int i=0;i<N;i++)
    {
        trkaci[i].first = i;
    }

    // Nalazimo k-to preticanje
    nadjiPreticanje(0,maxT);
    cout<<najmanje;


    // Debug
    //cout<<endl<<endl;
    //noviNiz(0.33333);
    //cout<<count_overtakes(initial_positions, final_positions);
    return 0;
}